import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import { useAuth } from "@/hooks/useAuth";
import { IndividualDashboard } from "@/components/IndividualDashboard";
import {OrganizationDashboard } from "@/pages/OrganizationDashboard";
import { PersonalTracker } from "@/components/PersonalTracker";
import Hero from "@/components/Hero"; // ✅ import the Hero component

type ActiveView = "dashboard" | "pdt" | "cdt" | "idt" | "odt";

const Index = () => {
  const [activeView, setActiveView] = useState<ActiveView>("dashboard");
  const { user, loading } = useAuth();
  const navigate = useNavigate();

  // While loading auth state
  if (loading) {
    return (
      <div className="min-h-screen flex items-center justify-center">
        <div className="text-lg">Loading...</div>
      </div>
    );
  }

  // ✅ If no user is authenticated, show the Hero landing page
  if (!user) {
    return <Hero />;
  }

  // ✅ Render authenticated dashboard views
  const renderActiveView = () => {
    switch (activeView) {
      case "pdt":
        return <PersonalTracker onBack={() => setActiveView("dashboard")} />;
      case "dashboard":
      default:
        return (
          <IndividualDashboard
            onNavigate={(view) => setActiveView(view as ActiveView)}
          />
        );
    }
  };

  return renderActiveView();
};

export default Index;
