import { clsx, type ClassValue } from "clsx"
import { twMerge } from "tailwind-merge"
import { supabase } from '@/components/supabaseClient';

export function cn(...inputs: ClassValue[]) {
  return twMerge(clsx(inputs))
}
// Check if user has career development access based on package_type
export const hasCareerDevelopmentAccess = (packageType: string | null | undefined): boolean => {
  return packageType === 'Pro';
};

// Get user package type and check access
export const getUserPackageInfo = async (userId: string): Promise<{
  packageType: string | null;
  hasCareerAccess: boolean;
}> => {
  const { data, error } = await supabase
    .from('users')
    .select('package_type')
    .eq('id', userId)
    .single();

  if (error) {
    console.error('Error getting user package info:', error);
    return { packageType: null, hasCareerAccess: false };
  }

  return {
    packageType: data.package_type,
    hasCareerAccess: data.package_type === 'Pro'
  };
};


