import React from "react";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Target, Zap, Crown, Check } from "lucide-react";

const plans = [
  {
    name: "Starter",
    price: "$9",
    period: "/month",
    description: "Perfect for individual players starting their journey",
    icon: <Target className="w-6 h-6" />,
    features: [
      "Basic shot tracking",
      "Weekly progress reports",
      "Mobile app access",
      "5 training sessions/week",
      "Email support",
    ],
    recommended: false,
    variant: "outline" as const,
  },
  {
    name: "Pro",
    price: "$29",
    period: "/month",
    description: "Advanced analytics for serious athletes",
    icon: <Zap className="w-6 h-6" />,
    features: [
      "Advanced shot analytics",
      "Real-time form analysis",
      "Unlimited training sessions",
      "Custom training programs",
      "Video breakdown tools",
      "Priority support",
      "Team collaboration",
    ],
    recommended: true,
    variant: "default" as const,
  },
  {
    name: "Elite",
    price: "$99",
    period: "/month",
    description: "Complete solution for teams and coaches",
    icon: <Crown className="w-6 h-6" />,
    features: [
      "Everything in Pro",
      "Multi-player tracking",
      "Coach dashboard",
      "Advanced team analytics",
      "Custom integrations",
      "On-site setup support",
      "24/7 priority support",
    ],
    recommended: false,
    variant: "secondary" as const,
  },
];

const Pricing = () => {
  return (
    <div className="py-20 bg-background">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-foreground mb-4">
            Choose Your <span className="bg-gradient-primary bg-clip-text text-transparent">Training Plan</span>
          </h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Select the perfect plan to elevate your basketball performance with AI-powered insights.
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8 max-w-6xl mx-auto">
          {plans.map((plan) => (
            <Card
              key={plan.name}
              className={`relative p-8 bg-card/50 backdrop-blur-sm border shadow-card hover:shadow-glow transition-all duration-300 ${
                plan.recommended
                  ? "border-primary scale-105 shadow-glow"
                  : "border-border hover:border-primary/50"
              }`}
            >
              {plan.recommended && (
                <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                  <div className="bg-gradient-primary text-foreground px-4 py-1 rounded-full text-sm font-medium">
                    Most Popular
                  </div>
                </div>
              )}

              <div className="text-center">
                <div className={`w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-4 ${
                  plan.recommended ? "bg-gradient-primary" : "bg-muted"
                }`}>
                  <div className="text-foreground">{plan.icon}</div>
                </div>

                <h3 className="text-2xl font-bold text-foreground mb-2">{plan.name}</h3>
                <p className="text-muted-foreground mb-6">{plan.description}</p>

                <div className="mb-8">
                  <span className="text-4xl font-bold text-foreground">{plan.price}</span>
                  <span className="text-muted-foreground">{plan.period}</span>
                </div>

                <Button variant={plan.variant} className="w-full mb-8" size="lg">
                  {plan.recommended ? "Start Pro Trial" : "Get Started"}
                </Button>
              </div>

              <div className="space-y-4">
                {plan.features.map((feature, i) => (
                  <div key={i} className="flex items-center space-x-3">
                    <Check className="w-5 h-5 text-primary flex-shrink-0" />
                    <span className="text-muted-foreground">{feature}</span>
                  </div>
                ))}
              </div>
            </Card>
          ))}
        </div>

        <div className="text-center mt-16">
          <p className="text-muted-foreground mb-4">
            All plans include a 14-day free trial. No credit card required.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button variant="ghost">Compare All Features</Button>
            <Button variant="outline">Contact Sales</Button>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Pricing;
