// src/components/OrganizationDashboard/Sidebar.tsx
import { NavLink, useParams } from 'react-router-dom';
import { Organization } from '../../types/organization';
import { FaUsers, FaEnvelope, FaCog, FaHome } from 'react-icons/fa';

interface SidebarProps {
  organization: Organization;
}

export function Sidebar({ organization }: SidebarProps) {
  const { orgId } = useParams();

  return (
    <aside className="sidebar">
      <div className="organization-info">
        <h2>{organization.name}</h2>
        <p>{organization.members.length} members</p>
      </div>
      
      <nav className="sidebar-nav">
        <NavLink 
          to={`/organization/${orgId}`} 
          end
          className={({ isActive }) => isActive ? 'active' : ''}
        >
          <FaHome /> Dashboard
        </NavLink>
        
        <NavLink 
          to={`/organization/${orgId}/members`}
          className={({ isActive }) => isActive ? 'active' : ''}
        >
          <FaUsers /> Members
        </NavLink>
        
        <NavLink 
          to={`/organization/${orgId}/invites`}
          className={({ isActive }) => isActive ? 'active' : ''}
        >
          <FaEnvelope /> Invites
        </NavLink>
        
        <NavLink 
          to={`/organization/${orgId}/settings`}
          className={({ isActive }) => isActive ? 'active' : ''}
        >
          <FaCog /> Settings
        </NavLink>
      </nav>
    </aside>
  );
}