import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { AuthProvider } from "@/hooks/useAuth";
import Index from "./pages/Index";
import Auth from "./pages/Auth";
import NotFound from "./pages/NotFound";
import Hero from "@/components/Hero";
import {IndividualDashboard } from "./components/IndividualDashboard";
import {DTTDashboard} from "./components/DTTDashboard";
import { DailyJournal } from "./components/DailyJournal";
import Dashboard from "./components/Dashboard";
import Goal from "./components/Goal";
import { HabitTracker as Habits } from "./components/Habits";
import BudgetTracker from "@/components/BudgetTracker";
import Budget from "@/components/Budget";
import CreateOrganization from "@/components/CreateOrganization";
import ProUpgrade from "@/components/ProUpgrade";
import PaymentPage from "@/components/PaymentPage";
import { SessionContextProvider } from "@supabase/auth-helpers-react";
import { supabase } from "@/components/supabaseClient";
import OrganizationDashboard  from './pages/OrganizationDashboard';
import { MembersList } from './components/OrganizationDashboard/MembersList';
import { CareerDevelopment } from '/src/components/CareerDevelopment';
import { OrganizationCareerDevelopment } from '/src/components/OrganizationCareerDevelopment';
import { PersonalTracker } from '/src/components/PersonalTracker';
import { OrganizationPersonalTracker } from '/src/components/OrganizationPersonalTracker';
import { Award, BarChart3, CheckCircle, Clock, Star, Users } from 'lucide-react';
import { Lightbulb, BookOpen, Target, TrendingUp } from 'lucide-react';
import {SkillDevelopment} from './components/SkillDevelopment';
import {OrganizationSkillDevelopment} from './components/OrganizationSkillDevelopment';
import { InnovationTracker } from './components/InnovationTracker';
import { OrganizationInnovationTracker } from './components/OrganizationInnovationTracker';
import { CareerGoals } from './components/CareerGoals';
import { Dialog } from './components/Dialog';
import { OrganizationCareerGoals } from './components/OrganizationCareerGoals';
import { OrganizationalTools } from './components/OrganizationalTools';
import { PoliticalStrategyDashboard } from './components/PoliticalStrategyDashboard';
import InviteManager  from './components/InviteManager';

const queryClient = new QueryClient();

const App = () => (
  
  <SessionContextProvider supabaseClient={supabase}>
    <QueryClientProvider client={queryClient}>
      <AuthProvider>
        <TooltipProvider>
          <Toaster />
          <Sonner />
          <BrowserRouter>
            <Routes>
              <Route path="/" element={<Index />} />
              <Route path="/Hero" element={<Hero />} />
              <Route path="/Auth" element={<Auth />} />
              <Route path="/IndividualDashboard" element={<IndividualDashboard />} />
              <Route path="/DailyJournal" element={<DailyJournal />} />
              <Route path="/Dashboard" element={<Dashboard />} />
              <Route path="/DTTDashboard" element={<DTTDashboard />} />
              <Route path="/Goal" element={<Goal />} />
              <Route path="/Habits" element={<Habits />} />
              <Route path="/BudgetTracker" element={<BudgetTracker />} />
              <Route path="/Budget" element={<Budget />} />
              <Route path="/OrganizationDashboard" element={<OrganizationDashboard />} />
              <Route path="/CreateOrganization" element={<CreateOrganization />} />
              <Route path="/PaymentPage" element={<PaymentPage />} />
              <Route path="/PersonalTracker" element={<PersonalTracker />} />
              <Route path="/OrganizationPersonalTracker" element={<OrganizationPersonalTracker />} />
              <Route path="/CareerDevelopment" element={<CareerDevelopment />} />
              <Route path="/OrganizationCareerDevelopment" element={<OrganizationCareerDevelopment />} />
              <Route path="/ProUpgrade" element={<ProUpgrade />} />
              <Route path="/SkillDevelopment" element={<SkillDevelopment />} />
              <Route path="/InnovationTracker" element={<InnovationTracker />} />
              <Route path="/CareerGoals" element={<CareerGoals />} />
              <Route path="/Dialog" element={<Dialog />} />
              <Route path="/OrganizationSkillDevelopment" element={<OrganizationSkillDevelopment />} />
              <Route path="/OrganizationInnovationTracker" element={<OrganizationInnovationTracker />} />
              <Route path="/OrganizationCareerGoals" element={<OrganizationCareerGoals />} />
              <Route path="/OrganizationalTools" element={<OrganizationalTools />} />
              <Route path="/PoliticalStrategyDashboard" element={<PoliticalStrategyDashboard />} />
              <Route path="/InviteManager" element={<InviteManager />} />
              


              
              {/* Catch-all 404 route */}
              <Route path="*" element={<NotFound />} />
            </Routes>
          </BrowserRouter>
        </TooltipProvider>
      </AuthProvider>
    </QueryClientProvider>
  </SessionContextProvider>
);

export default App;
