import { NextResponse } from 'next/server';
import { db } from '@/lib/db'; // Assuming you have a db client setup

export async function GET() {
  try {
    // In a real app, you'd get the user ID from the session
    const userId = 1; // Replace with actual user ID from session
    
    const user = await db.organization_members.findUnique({
      where: { id: userId },
      select: { username: true }
    });

    if (!user) {
      return NextResponse.json({ error: 'User not found' }, { status: 404 });
    }

    return NextResponse.json({ username: user.username });
  } catch (error) {
    return NextResponse.json(
      { error: 'Failed to fetch user data' },
      { status: 500 }
    );
  }
}